package fr.asip.cps3.exemple.vues.ecrans.resultats;

import java.awt.Color;
import java.awt.GridBagLayout;
import java.util.Iterator;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ScrollPaneConstants;
import javax.swing.border.EmptyBorder;

import fr.asip.cps3.exemple.modele.resultats.ResultatInfo;
import fr.asip.cps3.exemple.vues.FenetrePrincipale;
import fr.asip.cps3.exemple.vues.composants.GridBagHelper;
import fr.asip.cps3.exemple.vues.ecrans.EcranUtil;

/**
 * Classe permettant de modliser l'cran de rsultats avec Informations
 */
public class SortieResultatInfo extends SortieResultat {

	/**
	 * Libell du champ Informations
	 */
	protected JLabel libelleInfos;
	
	/**
	 * Texte du champ Informations
	 */
	protected JTextArea texteInfos;
	
	/**
	 * Scrollbar associe au champ Informations
	 */
	protected JScrollPane scrollInfos;
	
	/**
	 * Constructeur
	 * @param fenetre La fentre qui doit contenir l'cran de rsultat
	 */
	public SortieResultatInfo(FenetrePrincipale fenetre) {

		super(fenetre);

    	libelleInfos = new JLabel("Informations : ");
        texteInfos = new JTextArea();
        scrollInfos = new JScrollPane(texteInfos,ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED,ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        
        texteInfos.setLineWrap(true);
        texteInfos.setWrapStyleWord(true);
        texteInfos.setEditable(false);
        scrollInfos.setBackground(Color.white);   
    	
	}
	
	/*
	 * (non-Javadoc)
	 * @see fr.asip.cps3.exemple.vues.ecrans.IEcran#affiche()
	 */
	public void affiche() {
    	
    	JFrame fenetre = this.fenetre.getFenetre();

    	if(fenetre != null && fenetre.getContentPane() != null) {    	
    	
	    	EcranUtil.supprimeTousLesComposants(((JPanel)fenetre.getContentPane()));
	
	    	// Cration du layout
	    	((JPanel)fenetre.getContentPane()).setBorder(new EmptyBorder(0, 0, 0, 0));
	        GridBagLayout layout = new GridBagLayout();
	        ((JPanel)fenetre.getContentPane()).setLayout(layout);
	        
	        if(texteInfos != null)
	        	texteInfos.setText("");
	        
	        // Ajout des composants
	        GridBagHelper g = new GridBagHelper(fenetre.getContentPane());
	        // Ligne 0
	        g.ajoute(libelleOperation, EcranUtil.styleLibelleSortie, 0, 0, 1, 1);
	        g.ajoute(texteOperation, EcranUtil.styleTexteSortie, 0, 1, 1, 4);
	        // Ligne 1
	        g.ajoute(libelleRetour, EcranUtil.styleLibelleSortie, 1, 0, 1, 1);
	        g.ajoute(texteRetour, EcranUtil.styleTexteSortie, 1, 1, 1, 4);
	        // Ligne 2
	        g.ajoute(libelleInfos, EcranUtil.styleLibelleLigneEntiere, 2, 0, 1, 5);
	        // Ligne 3
	        g.ajoute(scrollInfos, EcranUtil.styleScrollInfos, 3, 0, 1, 5);
	        // Ligne 4
	        if(barreStatut != null)
	        	barreStatut.setText(this.fenetre.getBarreStatut().getText());
	        g.ajoute(barreStatut, EcranUtil.styleBarreStatut, 4, 0, 1, 6);
	        
			texteInfos.setEditable(true);
    	}

    }

	/**
	 * Affecte les informations
	 * @param infos Les informations
	 */
	public void setInfos(ResultatInfo infos) {
		if(infos != null) {
	        if(texteInfos != null)
	        	texteInfos.setText("");
			for (Iterator<String> iterator = infos.getInfos().keySet().iterator(); iterator.hasNext();) {
				String info = iterator.next();
				texteInfos.append(info+" : "+infos.getInfos().get(info)+"\n");
			}
		}
	}

}
